class HealthMod extends DMMutator config(UMHealthMod);

//Health bonus:
var config bool		bUseHealthBonus,
			bHealthBonusOnBots;
var config int		BonusHealth,
			TimeBetweenBonuses;
var int			Counter;

//Health Regen:
var config bool		bUseHealthRegen,
			bHealthRegenOnBots;
var config int		HealPerSecond,
			MaxHealthPlayers,
			MaxHealthBots;

//Default Spawn Settings:
var config int		DefaultPlayerHealth,
			DefaultBotHealth;

//Default Pickup Settings:
var config bool		bUseCustomPickupSettings;
var config int		HealthVialHealingAmount,
			MedBoxHealingAmount,
			HealtPackageHealingAmount;

//Rewards when fragging:
var config bool		bRewardBots;
var config int		HealthPoints,
			HeadShotHealthPoints,
			AmmoPoints,
			HeadShotAmmoPoints;

function PostBeginPlay() 
{
	Super.PostBeginPlay();

	SetTimer(1.0,True);

	Counter = TimeBetweenBonuses;

	//SaveConfig();
	
}

function Timer()
{
	Super.Timer();

	if ( bUseHealthBonus )
		{
		HealthBonus();
		}
	if ( bUseHealthRegen )
		{
		HealthRegen();
		}
}

function HealthRegen()
{
local Pawn P;
local int i;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( P.IsA('PlayerPawn'))
			{
			for (i=0;i<HealPerSecond;i++)
				{
				if ( P.Health < MaxHealthPlayers )
					P.Health++;
				}
			}
		else if ( P.IsA('Bot') && bHealthRegenOnBots )
			{
			for (i=0;i<HealPerSecond;i++)
				{
				if ( P.Health < MaxHealthBots )
					P.Health++;
				}
			}
		}
}

function HealthBonus()
{
local Pawn P;
local int NumPawns, Dice;

	Counter--;

	if ( Counter < 0 )
		{
		NumPawns = 0;
		Counter = TimeBetweenBonuses;
		//find NumPawns:
		for (P = Level.PawnList; P != None; P = P.NextPawn)
			{
			if ( P.IsA('PlayerPawn'))
				NumPawns++;
			else if ( P.IsA('Bot') && bHealthBonusOnBots )
				NumPawns++;
			}
		//give bonus:
		Dice = Rand(NumPawns + 1);
		NumPawns = 0;
		if ( bHealthBonusOnBots )
			{
			for (P = Level.PawnList; P != None; P = P.NextPawn)
				{
				if ( P.IsA('PlayerPawn'))
					{
					if ( Dice == NumPawns )
						{
						P.Health += BonusHealth;
						P.ReceiveLocalizedMessage( class'HealthBonusMessage' );
						BroadcastMessage( P.PlayerReplicationInfo.PlayerName$" recieved the healthbonus of "$BonusHealth$" points.", false );
						}
					NumPawns++;
					}
				else if ( P.IsA('Bot'))
					{
					if ( Dice == NumPawns )
						{
						P.Health += BonusHealth;
						P.ReceiveLocalizedMessage( class'HealthBonusMessage' );
						BroadcastMessage( P.PlayerReplicationInfo.PlayerName$" recieved the healthbonus of "$BonusHealth$" points.", false );
						}
					NumPawns++;
					}
				}
			}
		else
			{
			for (P = Level.PawnList; P != None; P = P.NextPawn)
				{
				if ( P.IsA('PlayerPawn'))
					{
					if ( Dice == NumPawns )
						{
						P.Health += BonusHealth;
						P.ReceiveLocalizedMessage( class'HealthBonusMessage' );
						BroadcastMessage( P.PlayerReplicationInfo.PlayerName$" recieved the healthbonus of "$BonusHealth$" points.", false );
						}
					NumPawns++;
					}
				}
			}
		}
}

function bool AlwaysKeep(Actor Other) 
{
	
	if (Other.IsA('HealthVial') && bUseCustomPickupSettings)
        	{
		HealthVial(Other).HealingAmount = HealthVialHealingAmount;
		return true;
		}
	if (Other.IsA('MedBox') && bUseCustomPickupSettings)
        	{
		MedBox(Other).HealingAmount = MedBoxHealingAmount;
		return true;
		}
	if (Other.IsA('HealthPack') && bUseCustomPickupSettings)
        	{
		HealthPack(Other).HealingAmount = HealtPackageHealingAmount;
		return true;
		}

	if (NextMutator != None)
		return (NextMutator.AlwaysKeep(Other));
	
	return false;
}


function ModifyPlayer(Pawn P)
{

	Super.ModifyPlayer(P);

	if ( P.IsA('PlayerPawn'))
		{
		P.Health = DefaultPlayerHealth;
 		}
	else if ( P.IsA('Bot'))
		{
		P.Health = DefaultBotHealth;
		}

}

function bool PreventDeath (Pawn Killed, Pawn Killer, name damageType, vector HitLocation)
{

	if ( Killer.IsA('Bot') && bRewardBots )
		{
		if ( Killer != Killed && Killer != none )
			{
			if ( DamageType == 'Decapitated' )
				{
				Killer.Health += HeadShotHealthPoints;
				}
			else
				{
				Killer.Health += HealthPoints;
				}
			if ( Killer.Weapon.AmmoType != none && Killer.Weapon.AmmoType.AmmoAmount != 0 )
				{
				if ( DamageType == 'Decapitated' )
					{
					Killer.Weapon.AmmoType.AmmoAmount += HeadShotAmmoPoints + 1;
					}
				else
					{
					Killer.Weapon.AmmoType.AmmoAmount += AmmoPoints + 1;
					}
				}
			}
		}
	else if ( Killer.IsA('PlayerPawn'))
		{
		if ( Killer != Killed && Killer != none )
			{
			if ( DamageType == 'Decapitated' )
				{
				Killer.Health += HeadShotHealthPoints;
				}
			else
				{
				Killer.Health += HealthPoints;
				}
			if ( Killer.Weapon.AmmoType != none && Killer.Weapon.AmmoType.AmmoAmount != 0 )
				{
				if ( DamageType == 'Decapitated' )
					{
					Killer.Weapon.AmmoType.AmmoAmount += HeadShotAmmoPoints + 1;
					}
				else
					{
					Killer.Weapon.AmmoType.AmmoAmount += AmmoPoints + 1;
					}
				}
			}
		}

	if ( NextMutator != None )
		NextMutator.ScoreKill(Killer, Killed);
}

defaultproperties
{
bUseHealthBonus=True
bHealthBonusOnBots=True
BonusHealth=100
TimeBetweenBonuses=60
bUseHealthRegen=True
bHealthRegenOnBots=True
HealPerSecond=5
MaxHealthPlayers=250
MaxHealthBots=250
DefaultPlayerHealth=100
DefaultBotHealth=100
bUseCustomPickupSettings=True
HealthVialHealingAmount=10
MedBoxHealingAmount=25
HealtPackageHealingAmount=150
HealthPoints=10
HeadShotHealthPoints=20
AmmoPoints=10
HeadShotAmmoPoints=10
}
